/**
 * Local: admin/quot/menu_quot.php, admin/quot/candidates.php
 * Controla o efeito dos botões de fornecedores e participantes.
 */

$('.show-candidates .bi').removeClass('bi-eye').addClass('bi-eye-slash');

$('.show-participants .bi').removeClass('bi-eye').addClass('bi-eye-slash');

if ($.cookie('candidates')) {

    $('.candidates').removeClass('d-none');

    $('.show-candidates .bi').removeClass('bi-eye-slash').addClass('bi-eye');

}

if ($.cookie('participants')) {

    $('.priority').addClass('d-none');

    $('.participants').removeClass('d-none');

    $('.show-participants .bi').removeClass('bi-eye-slash').addClass('bi-eye');
}

$(

    /**
     * Local: Afeta todas as páginas.
     * Descomentar a linha abaixo para reduzir os balões de dica. 
     */

    // $('.btn, a, li').removeAttr('data-bs-original-title'),

    /**
     * Local: admin/store/menu_store.php, admin/quot/form_quot.php
     * Dispara o botão do formulário de criação da cotação, para o administrador selecionar o arquivo.csv.
     */

    $('.select-quot').on('click', (data) => {

        $('.add-quot').trigger('click');

    }),
    /**
     * Local:admin/quot/form_quot.php
     * Submete o arquivo .csv para criar a cotação.
     */


    $('.add-quot').on('change', () => {

        $('.submit-quot').trigger('click');

    }),

    /**
     *  Local: admin/quot/menu_quot.php, admin/quot/candidates.php
     *  Controla a exposição de fornecedores para serem gerenciados na cotação.  
     */

    $('.show-candidates').on('click', () => {

        if (!$.cookie('candidates')) {

            $.cookie('candidates', 'show', { path: '/' });

            $('.candidates').removeClass('d-none');

            $('.show-candidates .bi').removeClass('bi-eye-slash').addClass('bi-eye');

        } else {

            $.removeCookie('candidates', { path: '/' })

            $('.candidates').addClass('d-none');

            $('.show-candidates .bi').removeClass('bi-eye').addClass('bi-eye-slash');

        }

    }),

    /**
     * Local: admin/quot/menu_quot.php, admin/product/home_product_table.php,
     * admin/product/organize_participants_table.php, 
     * Controla a exposição de participantes na tabela de produtos.
     * Controla também a exposição do botão "Selecionar menor valor" localizado na header da tabela,
     * no campo "Descrição".
     */

    $('.show-participants').on('click', () => {

        if (!$.cookie('participants')) {

            $.cookie('participants', 'show', { path: '/' });

            $('.priority').addClass('d-none');

            $('.participants').removeClass('d-none');

            $('.show-participants .bi').removeClass('bi-eye-slash').addClass('bi-eye');

        } else {

            $.removeCookie('participants', { path: '/' });

            $('.priority').removeClass('d-none');

            $('.participants').addClass('d-none');

            $('.show-participants .bi').removeClass('bi-eye').addClass('bi-eye-slash');

        }

    }),
    /**
     * Local: admin/product/form_product_modal.php
     * Abre o modal com o formulário para editar o campo quantidade dos produtos.
     */


    $('.edit-qtd').on('click', (data) => {

        let id_product = $(data.target).attr('id');

        let value_qtd = $(data.target).text().trim();

        $('.modal-title').html('Editar a quantidade');

        $('.input-hidden-id-product').val(id_product);

        $('.input-edit').val(value_qtd);

        $('.show-modal').trigger('click');

        setTimeout(() => {
            $('.input-edit').focus()
        }, 500);

    }),

    /**
     * Local: supplier/product/form_product_modal.php
     * Abre o modal com formulário para o participante adicionar o valor ao produto.
     */

    $('.add-value-supplier').on('click', (data) => {

        let id_product = $(data.target).attr('id');

        let obs = $(data.target).attr('obs');

        let td = $(data.target).attr('td');

        let value_product = $(data.target).text().trim();

        let array_td = td.split('&');

        let table_td = '';

        array_td.map((td) => {

            table_td += '<td>' + td + '</td>';

        });


        $('.table-modal').html(table_td);

        $('.input-hidden-id-product-supplier').val(id_product);

        $('.show-modal-supplier').trigger('click');

        $('.input-value').val(value_product != '0,00' ? value_product : '');

        $('#obs').val(obs);

        setTimeout(() => {
            $('.input-value').focus();
        }, 500);

        $('input, textarea').on('keypress', (event) => {

            if (event.which == 13) {

                $('.submit').trigger('click');

            }

        });

    }),

    /**
     * Local: supplier/quot/menu_quot.php
     * Controla a ativação da função de inserção por teclado (sem auxílio do mouse).
     */

    $('.keyboard-only').on('click', () => {

        if (!$.cookie('keyboard-only')) {

            $.cookie('keyboard-only', 'active', { path: '/' });

            $('.keyboard-only').removeClass('btn-danger').addClass('btn-success');

        } else {

            $.removeCookie('keyboard-only', { path: '/' });

            $('.keyboard-only').removeClass('btn-success').addClass('btn-danger');
        }

    }),

    /** 
    * Função que marca os valores iguais do mesmo produto para o administrador.
    * 
    * Em desenvolvimento.
    */

    // equal_values(),
);

// function equal_values() {

//     let tr_equal_values = $('tr');

//     let equal_values;

//     let ref;

//     // $('table').html('w '+tr_equal_values[0]);

//     tr_equal_values.each((t) => {

//         equal_values = $(tr_equal_values[t] + ' .equal');

//         $('table').html('w ');

//         ref = 100000;

//         equal_values.each((value) => {

//             if (equal_values[value].id < ref) {

//                 ref = equal_values[value].id;

//             }

//         });

//         equal_values.each((value) => {

//             if (equal_values[value].id == ref) {

//                 $(equal_values[value]).removeClass('text-black').addClass('text-danger fw-bold blink');

//             }

//         });

//         equal_values = '';


//     });



// }

/**
 * Local: Ativado a partir do botão localizado em supplier/quot/menu_quot.php
 * Inserção dinâmica de valores utilizando apenas o teclado (sem auxílio do mouse). 
 */

if ($.cookie('keyboard-only')) {

    let id_product = parseInt(window.location.href.split('#')[1]);

    document.getElementById(id_product + 1).click();

}

/**
 * Local: admin/product/home_product_table.php,
 * Atualiza as barras de progresso dos participantes da cotação.
 */

if ($('div').hasClass('progress-bar')) {

    let link_progress_by_participant = $('.table').attr('id');

    let url = link_progress_by_participant.split('&')[0];

    let id_quot = link_progress_by_participant.split('&')[1];

    progressParticipants();

    setInterval(() => {

        progressParticipants();

    }, 60000);

    function progressParticipants() {

        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: {
                id_quot: id_quot
            },
            success: function (data) {

                data.progress.forEach((user) => {

                    $('#' + user['id_participant']).
                        css('width', user['percent_user'] + '%').
                        attr('data-bs-original-title', '<b>Progresso</b><br>' + user['percent_user'] + '% concluído.').
                        text(user['percent_user'] + '%').addClass('progress-bar-striped');

                });

            }
        });

        setTimeout(() => {

            $('.progress-bar').removeClass('progress-bar-striped');

        }, 3000);
    }

}