/**
 * Variáveis do efeito de abre e fecha da porta do botão "Logout".
 */

let door_open = 'bi-door-open', door_closed = 'bi-door-closed';
/**
 * Ativa o balão "tooltip" do atributo "title". 
 */
const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

/**
 * Controla o ícone do botão "Tema".
 * 
 */

if (!$.cookie('theme')) {

    $('.change-theme .bi').removeClass('bi-moon').addClass('bi-sun');

} else {

    $('.change-theme .bi').removeClass('bi-sun').addClass('bi-moon');
}

$(
    /**
     * Controla o botão hamburger do menu fixo (não está sendo usado).
     */

    $('.w-link').on('click', () => {

        if ($('.navbar-collapse').hasClass('show')) {

            $(".navbar-toggler").trigger('click');

        }

    }),

    /**
     * Faz o efeito de abrir e fechar a porta do botão "Logout".
     */

    $('.out').mouseover(() => {

        $('.out .bi').removeClass(door_closed).addClass(door_open);

    }).mouseout(() => {

        $('.out .bi').removeClass(door_open).addClass(door_closed);

    }),

    /**
     * Local: todos os menus de usuários.
     * Muda o tema.
     */

    $('.change-theme').on('click', () => {

        if (!$.cookie('theme')) {

            $('.theme').attr('data-bs-theme', 'white');

            $.cookie('theme', 'white', { path: '/' });

            $('.change-theme .bi').removeClass('bi-sun').addClass('bi-moon');

        } else {

            $('.theme').attr('data-bs-theme', 'dark');

            $.removeCookie('theme', { path: '/' });

            $('.change-theme .bi').removeClass('bi-moon').addClass('bi-sun');

        }

    }),

    /**
     * Local: user/menu_user.php, user/form_message_modal.php
     * Abre o modal de mensagem do administrador para os fornecedores.
     */

    $('.add-message').on('click', () => {

        $('.show-modal-message').trigger('click');

        setTimeout(() => {

            $('.textarea-message').focus();

        }, 500);
    }),

    /**
     * Local: admin/winner/home_winner_table.php,
     * supplier/product/order_product_table.php, stockist/winner/home_winner_table.php
     * Efeito para marcar temporariamente a linha dos produtos na tabela de pedidos.
     */

    $('.w-mark').on('click', (w) => {

        let tr = $(w.target).closest('tr');

        if (tr.hasClass('w-marked')) {

            tr.removeClass('w-marked');
        } else {

            tr.addClass('w-marked');
        }

    }),

);

