<div class="row row-cols-md-1 row-cols-lg- row-cols-xxl-">

    <div class="col">

        <table class="table wtable-sm wtable-striped table-bordered table-hover">

            <thead class="table-secondary">

                <tr>

                    <th scope="col" class="text-center">Código</th>

                    <th scope="col" class="text-center">Descrição</th>

                    <th scope="col" class="text-center">Referência</th>

                    <th scope="col" class="text-center">Valor</th>

                    <th scope="col" class="text-center" data-bs-toggle="tooltip" title="Quantidade">Qtd</th>

                    <th class="text-center">Subtotal</th>

                </tr>

            </thead>

            <tbody>

                <?php

                $total = 0;

                foreach ($order as $product): ?>

                    <tr
                        class="w-mark"
                        style="cursor:pointer;"
                        data-bs-toggle="tooltip"
                        data-bs-html="true"
                        data-bs-placement="bottom"
                        <?= ($product->vencedor == -10) ?
                            ' class="table-warning equal-values" title="<b>Linha com valores iguais</b>"' :
                            ''
                        ?>>

                        <td class=" text-end pe-2">

                            <?= $product->codigo ?>

                        </td>

                        <?php

                        // Calcula o estoque.

                        $stock = ((int)$product->min - $product->quantidade);

                        $stock = ($stock > 0) ? $stock : 0;

                        ?>

                        <td>

                            <span
                                data-bs-toggle="tooltip"
                                data-bs-html="true"
                                title='<b class="text-start text-succes" style="text-align: start!important;">
                                <span class="text-success">Aplicação:</span><br>
                                <?= str_replace('/', '<br>', $product->aplicacao); ?>'>
                                <?= $product->descricao ?>
                            </span>

                        </td>

                        <td class=""><?= $product->referencia ?></td>

                        <td class="text-end">

                            R$ <?= number_format($product->valor, 2, ',', '.') ?>

                        </td>

                        <td class=" text-end pe-3" style="max-width: 1rem;">

                            <span
                                data-bs-toggle="tooltip"
                                title="Mudar a quantidade">

                                <?= ($product->quantidade < 10) ? '&nbsp;&nbsp;' : '' ?><?= $product->quantidade ?>

                            </span>

                        </td>

                        <td class="text-end">

                            <?php

                            $sub = ($product->valor * $product->quantidade);

                            $total += $sub;

                            ?>

                            R$ <?= number_format($sub, 2, ',', '.') ?>

                        </td>

                    </tr>

                <?php endforeach; ?>

            </tbody>

        </table>

    </div>

</div>

<script>
    document.querySelector('.total').innerText = 'Total R$<?= number_format($total, 2, ',', '.') ?>';
</script>