<div class="container-lg col-lg-4" data-bs-theme="dark">

    <?= view('message_error'); ?>

    <?= form_open('a/store/save', ['class' => 'form-control bg-body-secondary', 'autocomplete' => 'off', 'id' => 'form_store']); ?>

    <div class="my-3">

        <?= view('button_go_back', [

            'page_back' => base_url((isset($store)) ? 'a/store/details/' . $store->idloja : 'a'),

        ]); ?>

    </div>

    <div class="my-3">

        <label for="nomeloja" class="form-label">Nome</label>

        <input
            type="text"
            name="nomeloja"
            id="nomeloja"
            class="form-control"
            value="<?= (isset($store)) ? $store->nomeloja : '' ?>"
            autofocus
            required
            minlength="3">

    </div>

    <div class="my-3">

        <label for="enderecoloja" class="form-label">Endereço</label>

        <input
            type="text"
            name="enderecoloja"
            id="enderecoloja"
            class="form-control"
            value="<?= (isset($store)) ? $store->enderecoloja : '' ?>"
            required
            minlength="3">

    </div>

    <div class="my-3">

        <label for="cnpjloja" class="form-label">CNPJ</label>

        <input
            type="text"
            name="cnpjloja"
            id="cnpjloja"
            class="form-control"
            value="<?= (isset($store)) ? $store->cnpjloja : '' ?>"
            required>

    </div>

    <div class="my-3">

        <label for="abreviacaoloja" class="form-label">Abreviação</label>

        <input
            type="text"
            name="abreviacaoloja"
            id="abreviacaoloja"
            class="form-control"
            value="<?= (isset($store)) ? $store->abreviacaoloja : '' ?>"
            required
            minlength="3">

    </div>

    <input type="hidden" name="idloja" value="<?= (isset($store)) ? $store->idloja : '' ?>">

    <div class="my-3">

        <button type="submit" class="btn btn-sm btn-success"><i class="bi bi-save"></i></button>

    </div>

    <?= form_close(); ?>

</div>

<script>
    function validaCNPJ(cnpj) {
        cnpj = cnpj.replace(/[^\d]+/g, '');
        if (cnpj == '' || cnpj.length != 14 || /^(\d)\1{13}$/.test(cnpj)) return false;

        // Valida DVs
        let tamanho = cnpj.length - 2
        let numeros = cnpj.substring(0, tamanho);
        let digitos = cnpj.substring(tamanho);
        let soma = 0;
        let pos = tamanho - 7;
        for (let i = tamanho; i >= 1; i--) {
            soma += numeros.charAt(tamanho - i) * pos--;
            if (pos < 2) pos = 9;
        }
        let resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(0)) return false;

        tamanho = tamanho + 1;
        numeros = cnpj.substring(0, tamanho);
        soma = 0;
        pos = tamanho - 7;
        for (let i = tamanho; i >= 1; i--) {
            soma += numeros.charAt(tamanho - i) * pos--;
            if (pos < 2) pos = 9;
        }
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(1)) return false;
        return true;
    }

    document.getElementById('form_store').addEventListener('submit', function(e) {
        var cnpj = document.getElementById('cnpjloja').value;
        if (!validaCNPJ(cnpj)) {
            e.preventDefault(); // Impede o envio do formulário
            alert('CNPJ inválido. Por favor, verifique o número digitado.');
            document.getElementById('cnpj').focus(); // Foca no campo de CNPJ após detectar erro
        }
    });

    document.getElementById('cnpjloja').addEventListener('input', function(e) {
        var value = e.target.value;
        var rawValue = value.replace(/\D/g, ''); // Remove tudo que não é número

        // Verifica se o CNPJ tem 15 dígitos e se o primeiro dígito é '0'
        if (rawValue.length === 15 && rawValue.startsWith('0')) {
            // Verifica se, ao remover o '0', o restante é um CNPJ válido
            var potentialCNPJ = rawValue.substring(1);
            // Atualiza rawValue para o CNPJ sem o '0' inicial
            if (validaCNPJ(potentialCNPJ)) rawValue = potentialCNPJ;
        }

        var cnpjPattern = rawValue
            .replace(/^(\d{2})(\d)/, '$1.$2') // Adiciona ponto após o segundo dígito
            .replace(/^(\d{2})\.(\d{3})(\d)/, '$1.$2.$3') // Adiciona ponto após o quinto dígito
            .replace(/\.(\d{3})(\d)/, '.$1/$2') // Adiciona barra após o oitavo dígito
            .replace(/(\d{4})(\d)/, '$1-$2') // Adiciona traço após o décimo segundo dígito
            .replace(/(-\d{2})\d+?$/, '$1'); // Impede a entrada de mais de 14 dígitos
        e.target.value = cnpjPattern;
    });
</script>