<?php

namespace App\Controllers\Supplier;

use App\Controllers\BaseController;
use App\Models\UserModel;

class SupplierMain extends BaseController
{

    public function __construct()
    {
        parent::__construct();

        if (session()->get('user') != 'Supplier') {
            session()->destroy();
        }
    }

    /**
     * Página inicial do fornecedor.
     */

    public function home(): string
    {

        $user = new UserModel();

        $message = $user
            ->select('nome, telefone')
            ->where('login', 'message')
            ->find();

        $return_message = ($message) ? $message[0]->nome . $message[0]->telefone : '';

        $stores = $this
            ->store
            ->distinct()
            ->select('loja.*')
            ->join('cotacao', 'loja.idloja=cotacao.loja_idloja')
            ->join('participante', 'cotacao.idcotacao=participante.cotacao')
            ->join('usuario', 'participante.usuario=usuario.idusuario')
            ->where(
                [
                    'usuario.idusuario' => session()->get('id_user'),
                    'cotacao.status!=' => 'f'
                ]
            )
            ->findAll();

        return view('index', [

            $this->CONTENT_TOP => view('supplier/store/home_store', [

                'title_store' => '',

                'stores' => $stores,

                'message' => $return_message,

            ]),
        ]);
    }
}
