<?php

namespace App\Controllers\Supplier;

class Store extends SupplierMain
{

    public function __construct()
    {
        parent::__construct();
    }

    public function details($id_store)
    {

        $result_quot  = $this->store
            ->join('cotacao', 'cotacao.loja_idloja=loja.idloja', 'left')
            ->join('participante', 'cotacao.idcotacao=participante.cotacao', 'left')
            ->where([
                'loja.idloja' => $id_store,
                'cotacao.status' => 'a',
                'participante.usuario' => session()->get('id_user')
            ])->orderBy('idcotacao', 'desc')->findAll();

        $title_store = '';

        if ($result_quot) {

            $store_local = explode('-', $result_quot[0]->abreviacaoloja);

            $title_store = (isset($store_local[1])) ? $store_local[1] : $result_quot[0]->abreviacaoloja;
        }

        $result_orders = $this->store
            ->join('cotacao', 'cotacao.loja_idloja=loja.idloja', 'left')
            ->join('participante', 'cotacao.idcotacao=participante.cotacao', 'left')
            ->where([
                'loja.idloja' => $id_store,
                'cotacao.status' => 'e',
                'participante.usuario' => session()->get('id_user')
            ])->orderBy('idcotacao', 'desc')->findAll();

        if ($result_orders) {

            $title_store = 'Cotações e pedidos da loja ' .
                $result_orders[0]->nomeloja .
                ' | ' .
                $result_orders[0]->enderecoloja .
                ' | ' .
                $result_orders[0]->cnpjloja;
        }

        return view('index', [

            'title_complement' => $title_store,

            $this->CONTENT_NORMAL => view('supplier/store/details_store', [

                'title_store' => '',

                'quots' => $result_quot,

                'orders' => $result_orders,

            ]),

        ]);
    }
}
