<?php

namespace App\Controllers\Supplier;

use App\Models\ParticipantsModel;
use App\Models\ProductModel;
use App\Models\ValuesModel;

class Quot extends SupplierMain
{

    public function __construct()
    {
        parent::__construct();
    }

    public function details($id_quot, $id_store)
    {
        $products = new ProductModel();

        $result = $products
            ->select(
                'produto.*, loja.abreviacaoloja, loja.enderecoloja, loja.cnpjloja, valores.valor, valores.obs, participante.concluido'
            )
            ->join('cotacao', 'cotacao.idcotacao=produto.cotacao_idcotacao')
            ->join('loja', 'loja.idloja=cotacao.loja_idloja')
            ->join('participante', 'participante.cotacao=cotacao.idcotacao')
            ->join('usuario', 'usuario.idusuario=participante.usuario')
            ->join('valores', 'valores.idusuario=usuario.idusuario and valores.idproduto=produto.idproduto', 'left')
            ->where(
                [
                    'loja.idloja' => $id_store,
                    'cotacao.idcotacao' => $id_quot,
                    'cotacao.status' => 'a',
                    'participante.usuario' => session()->get('id_user'),
                    'produto.quantidade >' => '0'
                ]
            )
            ->paginate(60);

        $title_quot = '';

        if ($result) {

            $name_store = $result[0]->abreviacaoloja;

            $local_store = $result[0]->enderecoloja;

            $cnpj_store = $result[0]->cnpjloja;

            $title_quot = 'Cotação da loja ' .
                $name_store .
                ' | ' .
                $local_store .
                ' | ' .
                $cnpj_store;
        }

        return view('index', [

            $this->CONTENT_NORMAL => view('supplier/quot/details_quot', [

                'title_quot' => $title_quot,

                'id_store' => $id_store,

                'id_quot' => $id_quot,

                'products' => $result,

                'pager' => $products->pager,
            ]),
        ]);
    }

    public function addValueObs()
    {
        $values = new ValuesModel();

        $id_product = $this->request->getPost('id_product');
        $id_store = $this->request->getPost('id_store');
        $id_quot = $this->request->getPost('id_quot');

        $value_product = str_replace('.', '', $this->request->getPost('value_product'));
        $value_product = str_replace(',', '.', $value_product);
        $value_product = trim($value_product);

        $obs_product = trim($this->request->getPost('obs'));

        if ($values
            ->where(
                [
                    'idproduto' => $id_product,
                    'idcotacao' => $id_quot,
                    'idusuario' => session()->get('id_user'),
                ]
            )
            ->findColumn('valor')
        ) {

            if ($value_product <= 0) {

                if (!$values->where(
                    [
                        'idproduto' => $id_product,
                        'idcotacao' => $id_quot,
                        'idusuario' => session()->get('id_user'),
                    ]
                )->delete()) {

                    return redirect()
                        ->to('f/quot/details/' . $id_quot . '/' . $id_store . $this->page)
                        ->with('error', 'Ocorreu um erro ao editar o valor, comunique ao administrador.');
                }

                return redirect()->to('f/quot/details/' . $id_quot . '/' . $id_store . $this->page . '#' . $id_product);
            }

            if (!$values
                ->set(
                    [
                        'valor' => $value_product,
                        'obs' => $obs_product,
                    ]
                )
                ->where(
                    [
                        'idproduto' => $id_product,
                        'idcotacao' => $id_quot,
                        'idusuario' => session()->get('id_user'),
                    ]
                )->update()) {

                return redirect()
                    ->to('f/quot/details/' . $id_quot . '/' . $id_store . $this->page)
                    ->with('error', 'Ocorreu um erro ao editar o valor, comunique ao administrador.');
            }
        } else {

            if (!$values
                ->save(
                    [
                        'valor' => $value_product,
                        'obs' => $obs_product,
                        'idproduto' => $id_product,
                        'idcotacao' => $id_quot,
                        'idusuario' => session()->get('id_user'),
                    ]
                )) {

                return redirect()
                    ->to('f/quot/details/' . $id_quot . '/' . $id_store . $this->page)
                    ->with('error', 'Ocorreu um erro ao adicionar o valor, comunique ao administrador.');
            }
        }

        return redirect()->to('f/quot/details/' . $id_quot . '/' . $id_store . $this->page . '#' . $id_product);
    }

    public function completed($link_option, $id_quot, $id_store)
    {

        $participant = new ParticipantsModel();

        if (!$participant
            ->set(
                [
                    'concluido' => $link_option
                ]
            )
            ->where(
                [
                    'cotacao' => $id_quot,
                    'usuario' => session()->get('id_user'),
                ]
            )->update()) {

            return redirect()
                ->to('f/quot/details/' . $id_quot . '/' . $id_store . $this->page)
                ->with('error', 'Ocorreu um erro ao finalizar a cotação, comunique ao administrador.');
        }

        return redirect()->to('f/quot/details/' . $id_quot . '/' . $id_store . $this->page);
    }
}
