<?php

namespace App\Controllers\Supplier;

use App\Models\ValuesModel;

class Order extends SupplierMain
{

    private $order, $values;

    public function __construct()
    {
        parent::__construct();

        $this->values = new ValuesModel();
    }

    public function details($id_quot, $id_store)
    {

        $data_store = $this->store->find($id_store);

        $this->order = $this->values
            ->select('usuario.nome, produto.*, valores.valor')
            ->join('usuario', 'usuario.idusuario=valores.idusuario')
            ->join('produto', 'produto.idproduto=valores.idproduto')
            ->join('cotacao', 'cotacao.idcotacao=produto.cotacao_idcotacao')
            ->where(
                [
                    'valores.idcotacao' => $id_quot,
                    'valores.idusuario' => session()->get('id_user'),
                    'produto.vencedor' => session()->get('id_user'),
                    'cotacao.status' => 'e',
                ]
            )
            ->findAll();

        return view(

            'index',

            [

                $this->CONTENT_NORMAL => view(

                    'supplier/order/details_order',

                    [
                        'title_order' => ($this->order) ? 'Pedido da loja ' .
                            $data_store->abreviacaoloja .
                            ' | ' .
                            $data_store->enderecoloja .
                            ' | ' .
                            $data_store->cnpjloja : 'Sem resultado...',

                        'order' => $this->order,

                        'id_store' => $id_store,
                    ]
                ),
            ]
        );
    }
}
