<?php

namespace App\Controllers\Stockist;

use App\Controllers\BaseController;

class StockistMain extends BaseController
{

    public function __construct()
    {

        parent::__construct();

        if (session()->get('user') != 'Stockist') {
            session()->destroy();
        }
    }

    /**
     * Página inicial do estoquista.
     */

    public function home()
    {

        $stores = $this
            ->store
            ->distinct()
            ->select('loja.*')
            ->join('cotacao', 'loja.idloja=cotacao.loja_idloja')
            ->where(
                [
                    'cotacao.status' => 'e'
                ]
            )
            ->findAll();

        return view('index', [

            $this->CONTENT_TOP => view('stockist/store/home_store', [

                'title_store' => '',

                'stores' => $stores,

                'message' => '',

            ]),
        ]);
    }
}
