<?php

namespace App\Controllers\Admin;

use App\Controllers\Admin\AdminMain;
use App\Models\UserModel;

class User extends AdminMain
{

    private $user;

    public function __construct()
    {

        parent::__construct();

        $this->user = new UserModel();
    }

    public function list()
    {

        $message = $this
            ->user
            ->select('nome, telefone')
            ->where('login', 'message')
            ->find();

        $return_message = ($message) ? $message[0]->nome . $message[0]->telefone : '';


        return view('index', [

            'title_complement' => 'Gerenciar usuários',

            $this->CONTENT_NORMAL => view('user/details_user', [

                'users' => $this->user->where('login !=', 'message')->orderBy('tipo', 'desc')->findAll(),

                'message' => $return_message,

            ]),

        ]);
    }

    public function create()
    {

        return view('index', [

            'title_complement' => 'Adicionar usuário',

            $this->CONTENT_NORMAL => view('user/form_user'),
        ]);
    }

    public function edit($id_user)
    {

        return view('index', [

            'title_complement' => 'Editar usuário',

            $this->CONTENT_NORMAL => view('user/form_user', [


                'user' => $this->user->find($id_user),
            ]),
        ]);
    }

    public function save()
    {
        $edit_password = '';

        $name = trim($this->request->getPost('nome'));

        $login = trim($this->request->getPost('login'));

        $password = $this->request->getPost('senha');

        $email = trim($this->request->getPost('email'));

        $phone_number = trim($this->request->getPost('telefone'));

        $type = $this->request->getPost('tipo');

        $id_user = $this->request->getPost('idusuario');

        $data = [
            'nome' => $name,
            'login' => $login,
            'senha' => md5(trim($password)),
            'email' => $email,
            'telefone' => $phone_number,
            'tipo' => $type,
            'idusuario' => $id_user,
        ];

        if (!$password) {

            unset($data['senha']);
        }

        if (!$this->user->save($data)) {

            return redirect()->to('a/user')->with('error', 'Ocorreu um erro ao salvar os dados do usuário.');
        }

        return redirect()->to('a/user');
    }

    /**
     * Mensagem do administrador aos fornecedores.
     */

    public function message()
    {

        $message = trim($this->request->getPost('message'));

        $message_split = mb_str_split($message, 40);

        $message_nome = (isset($message_split[0])) ? $message_split[0] : '';

        $message_telefone = (isset($message_split[1])) ? $message_split[1] : '';

        if (!$this
            ->user
            ->set(['nome' => $message_nome, 'telefone' => $message_telefone])
            ->where('login', 'message')->update()) {

            return redirect()->to('a/user')->with('error', 'Ocorreu um erro ao enviar messagem aos participantes.');
        }

        return redirect()->to('a/user');
    }

    public function delete($id_user)
    {

        if (!$this->user->delete($id_user)) {

            return redirect()->to('a/user')->with('error', 'Ocorreu um erro ao excluir o usuário.');
        }

        return redirect()->to('a/user');
    }
}
