<?php

namespace App\Controllers\Admin;

use App\Controllers\Admin\AdminMain;

use App\Models\QuotModel;

class Store extends AdminMain
{

    public function __construct()
    {

        parent::__construct();
    }


    public function create()
    {

        return view('index', [

            'title_complement' => 'Adicionar loja',

            $this->CONTENT_NORMAL => view('admin/store/form_store', [])

        ]);
    }

    public function edit($id_store)
    {

        return view('index', [

            'title_complement' => 'Editar loja ' . $this->nameStore($id_store),

            $this->CONTENT_NORMAL => view('admin/store/form_store', [

                'store' => $this->store->find($id_store),
            ])

        ]);
    }

    public function details($id_store)
    {

        $quot = new QuotModel();

        $store = $this->store->find($id_store);

        return view('index', [

            'title_complement' => 'Gerenciamento da loja ' . $this->nameStore($id_store),

            $this->CONTENT_NORMAL => view('admin/store/details_store', [

                'store' => $store,

                'quots' => $quot->where('loja_idloja', $id_store)->orderBy('idcotacao', 'desc')->findAll(),
            ])

        ]);
    }

    public function save()
    {

        if (!$this->store->save($this->request->getPost())) {

            return redirect()->to('admin/store/edit/' . $this->request->getPost('idloja'))->with('error', 'Ocorreu um erro ao salvar a loja.');
        }

        return redirect()->to('/a');
    }

    public function delete($id_store)
    {

        if (!$this->store->delete($id_store)) {

            return redirect()->to('admin/store/details/. $id_store')->with('error', 'Ocorreu um erro ao excluir a loja.');
        }

        return redirect()->to('/a');
    }
}
