<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

$routes->group('a', ['filter' => 'auth'], function ($routes) {

    $user = session()->get('user');

    $routes->get('/', $user . '\AdminMain::home');

    // Usuários

    $routes->get('user', $user . '\User::list');
    $routes->get('user/create', $user . '\User::create');
    $routes->get('user/edit/(:num)', $user . '\User::edit/$1');
    $routes->post('user/save', $user . '\User::save');
    $routes->get('user/delete/(:num)', $user . '\User::delete/$1');


    //  Mensagem aos fornecedores.

    $routes->post('user/message', $user . '\User::message');

    // Loja

    $routes->get('store/create', $user . '\Store::create');
    $routes->get('store/edit/(:num)', $user . '\Store::edit/$1');
    $routes->get('store/delete/(:num)', $user . '\Store::delete/$1');
    $routes->get('store/details/(:num)', $user . '\Store::details/$1');
    $routes->post('store/save', $user . '\Store::save');

    // Cotação

    $routes->get('quot', $user . '\AdminMain::quot');
    $routes->post('quot/create', $user . '\Quot::create');
    $routes->get('quot/edit/(:any)/(:num)/(:num)', $user . '\Quot::edit/$1/$2/$3');
    $routes->get('quot/details/(:num)/(:num)', $user . '\Quot::details/$1/$2');
    $routes->get('quot/add_supplier/(:num)/(:num)/(:num)', $user . '\Quot::addSupplier/$1/$2/$3');
    $routes->get('quot/remove_supplier/(:num)/(:num)/(:num)', $user . '\Quot::removeSupplier/$1/$2/$3');
    $routes->get('quot/select_value/(:num)/(:num)/(:num)/(:num)', $user . '\Quot::selectValue/$1/$2/$3/$4');
    $routes->get('quot/remove_value/(:num)/(:num)/(:num)/(:num)', $user . '\Quot::removeValue/$1/$2/$3/$4');
    $routes->get('quot/select_lowest_price/(:num)/(:num)', $user . '\Quot::selectLowestPrice/$1/$2');
    $routes->post('quot/edit_qtd', $user . '\Quot::editQtd');
    $routes->get('quot/change_status_product/(:any)/(:num)/(:num)/(:num)', $user . '\Quot::changeStatusProduct/$1/$2/$3/$4');
    $routes->get('quot/delete/(:num)/(:num)', $user . '\Quot::delete/$1/$2');

    $routes->post('quot/progress_by_participant', $user . '\Quot::progressByParticipant');

    // Pedidos

    $routes->get('order/orders_by_quot/(:num)/(:num)', $user . '\Order::ordersByQuot/$1/$2');
    $routes->get('order/details_by_winner/(:num)/(:num)/(:num)', $user . '\Order::detailsByWinner/$1/$2/$3');
    $routes->get('order/generate_csv/(:num)/(:num)', $user . '\Order::generateCsv/$1/$2');
});


$routes->group('f', ['filter' => 'auth'], function ($routes) {

    $user = session()->get('user');

    $routes->get('/', $user . '\SupplierMain::home');

    $routes->get('store/details/(:num)', $user . '\Store::details/$1');

    $routes->get('quot/details/(:num)/(:num)', $user . '\Quot::details/$1/$2');
    $routes->post('quot/add_value_obs/', $user . '\Quot::addValueObs');
    $routes->get('quot/completed/(:any)/(:num)/(:num)', $user . '\Quot::completed/$1/$2/$3');

    $routes->get('order/details/(:num)/(:num)', $user . '\Order::details/$1/$2');
});

$routes->group('e', ['filter' => 'auth'], function ($routes) {

    $user = session()->get('user');

    $routes->get('/', $user . '\StockistMain::home');

    $routes->get('store/details/(:num)', $user . '\Store::details/$1');

    $routes->get('order/orders_by_quot/(:num)/(:num)', $user . '\Order::ordersByQuot/$1/$2');
    $routes->get('order/details_by_winner/(:num)/(:num)/(:num)', $user . '\Order::detailsByWinner/$1/$2/$3');
});

$routes->get('/', 'Unknown::logout');
$routes->get('login', 'Unknown::login');
$routes->post('signin', 'Unknown::signIn');
$routes->get('logout', 'Unknown::logout');
